/*
 * Module: rl_nat.hh
 *
 * **** License ****
 * Version: VPL 1.0
 *
 * The contents of this file are subject to the Vyatta Public License
 * Version 1.0 ("License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.vyatta.com/vpl
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * This code was originally developed by Vyatta, Inc.
 * Portions created by Vyatta are Copyright (C) 2005, 2006, 2007 Vyatta, Inc.
 * All Rights Reserved.
 *
 * Author: Michael Larson
 * Date: 2005
 * Description:
 *
 * **** End License ****
 *
 */

#ifndef __RL_NAT_HH__
#define __RL_NAT_HH__


#include <map>
#include <set>
#include <string>
#include <libxipc/xrl_error.hh>
#include <libxorp/ipv4.hh>
#include <libxorp/ipv4net.hh>

class rlIPv4Net {
public:
  rlIPv4Net(IPv4Net &net) : _net(net), _is_valid(true) {
  }

  rlIPv4Net(const IPv4Net &net) : _net(net), _is_valid(true) {
  }

  rlIPv4Net() :  _is_valid(false) {
  }

  void set(const IPv4Net &net) {_net = net; _is_valid = true;}

  void clear() {_net = IPv4Net(); _is_valid = false;}

  bool is_valid() const {return _is_valid;}

  string str() const {return _net.str(); }

  const IPv4 masked_addr() const {return _net.masked_addr();}

  const IPv4 top_addr() const {return _net.top_addr();}

private:
  IPv4Net _net;
  bool _is_valid;
};

class NATData 
{
public:
  typedef set<string> AppColl;
  typedef set<string>::iterator AppIter;
  typedef set<string>::const_iterator ConstAppIter;

  typedef set<uint32_t> PortColl;
  typedef set<uint32_t>::iterator PortIter;
  typedef set<uint32_t>::const_iterator ConstPortIter;

  NATData();

  XrlCmdError create_rule(string &rule) const;

  string dump() const;

public:
  string _type;
  string _trans_type;
  string _in_interface;
  string _out_interface;
  string _protocol;
  IPv4 _src_address;
  rlIPv4Net _src_network;
  PortColl _src_ports;
  AppColl _src_port_apps;
  uint32_t _src_port_start;
  uint32_t _src_port_stop;
  IPv4 _dst_address;
  rlIPv4Net _dst_network;
  PortColl _dst_ports;
  AppColl _dst_port_apps;
  uint32_t _dst_port_start;
  uint32_t _dst_port_stop;
  IPv4 _in_address;
  rlIPv4Net _in_network;
  IPv4 _out_address;
  rlIPv4Net _out_network;
  IPv4 _out_address_start;
  IPv4 _out_address_stop;

  bool _is_new;
};
#endif //__RL_NAT_HH__
