/*
 * Module: rl_mem_trace.hh
 *
 * **** License ****
 * Version: VPL 1.0
 *
 * The contents of this file are subject to the Vyatta Public License
 * Version 1.0 ("License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.vyatta.com/vpl
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * This code was originally developed by Vyatta, Inc.
 * Portions created by Vyatta are Copyright (C) 2005, 2006, 2007 Vyatta, Inc.
 * All Rights Reserved.
 *
 * Author: Michael Larson
 * Date: 2005
 * Description:
 *
 * **** End License ****
 *
 */
#ifndef __RL_MEM_TRACE_HH__
#define __RL_MEM_TRACE_HH__

#include <stdio.h>
#include <iostream>
#include <map>

using namespace std;

class RLMemTrace
{
public:
  //tracks memory instance
  typedef map<long, string> MemColl;
  typedef map<long, string>::iterator MemIter;

  //tracks count of allocation at new location
  typedef map<string, int> MemCtColl;
  typedef map<string, int>::iterator MemCtIter;

public:
  RLMemTrace(string file, int line) {
    _file = file;
    _line = line;
  }


  static void
  record_alloc(long ptr, string file, int line);

  static void
  record_delete(void* ptr);
    
  static void
  dump(ostream& os);

private:
  static string _file;
  static int _line;

  static MemColl _mem_coll;
  static MemCtColl _mem_ct_coll;
};

void* operator new(size_t size, const char* file, int line);
void* operator new[](size_t size, const char* file, int line);

#ifndef __DO_NOT_REPLACE_REDEF_OP_NEW__
#define new new(__FILE__, __LINE__)
#endif

void operator delete(void* ptr);
void operator delete[](void* ptr);

#endif //__RL_MEM_TRACE_HH__
