/*
 * Module: rl_mem_trace.cc
 *
 * **** License ****
 * Version: VPL 1.0
 *
 * The contents of this file are subject to the Vyatta Public License
 * Version 1.0 ("License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.vyatta.com/vpl
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * This code was originally developed by Vyatta, Inc.
 * Portions created by Vyatta are Copyright (C) 2005, 2006, 2007 Vyatta, Inc.
 * All Rights Reserved.
 *
 * Author: Michael Larson
 * Date: 2005
 * Description:
 *
 * **** End License ****
 *
 */
#include <map>
#include <iostream>

#define __DO_NOT_REPLACE_REDEF_OP_NEW__

#include "rl_mem_trace.hh"

RLMemTrace::MemColl RLMemTrace::_mem_coll;
RLMemTrace::MemCtColl RLMemTrace::_mem_ct_coll;

using namespace std;

/**
 *
 **/
void
RLMemTrace::record_alloc(long ptr, string file, int line)
{
  char buf[20];
  sprintf(buf, "%d", line);
  string loc = string(file) + ":" + string(buf);
  
  RLMemTrace::_mem_coll[ptr] = loc;
  MemCtIter iter_ct = RLMemTrace::_mem_ct_coll.find(loc);
  if (iter_ct != RLMemTrace::_mem_ct_coll.end()) {
    RLMemTrace::_mem_ct_coll[loc] = ++(iter_ct->second);
  }
  else {
    RLMemTrace::_mem_ct_coll.insert(pair<string, int>(loc, 1));
  }
}


/**
 *
 **/
void
RLMemTrace::record_delete(void* ptr) {
  MemIter iter = _mem_coll.find(long(ptr));
  if (iter != _mem_coll.end()) {
    _mem_ct_coll[iter->second] = --_mem_ct_coll[iter->second];
    _mem_coll.erase(iter);
  }
}

/**
 *
 **/
void
RLMemTrace::dump(ostream& os) 
{
  int tot_ct = 0;
  MemCtIter iter = _mem_ct_coll.begin();
  while (iter != _mem_ct_coll.end()) {
    os << iter->first << ", " << iter->second << endl;
    tot_ct += iter->second;
    ++iter;
  }
  os << "total objects: " << tot_ct << endl;
}

/**
 *
 **/
void operator delete(void* ptr) 
{
  if (ptr != NULL) {
    RLMemTrace::record_delete(ptr);
    free(ptr);
  }
}

/**
 *
 **/
void operator delete[](void* ptr) 
{
  if (ptr != NULL) {
    RLMemTrace::record_delete(ptr);
    free(ptr);
  }
}

/**
 *
 **/
void* operator new(size_t size, const char* file, int line) {
  void* ptr = malloc(size);
  RLMemTrace::record_alloc(long(ptr), file, line);
  return ptr;
}

/**
 *
 **/
void* operator new[](size_t size, const char* file, int line) {
  void* ptr = malloc(size);
  RLMemTrace::record_alloc(long(ptr), file, line);
  return ptr;
}
