/*
 * Module: rl_interface.cc
 *
 * **** License ****
 * Version: VPL 1.0
 *
 * The contents of this file are subject to the Vyatta Public License
 * Version 1.0 ("License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.vyatta.com/vpl
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * This code was originally developed by Vyatta, Inc.
 * Portions created by Vyatta are Copyright (C) 2005, 2006, 2007 Vyatta, Inc.
 * All Rights Reserved.
 *
 * Author: Michael Larson
 * Date: 2005
 * Description:
 *
 * **** End License ****
 *
 */
#include <string>

#include <sys/time.h>
#include <string.h>
#include <err.h>
#include <sys/ioctl.h>
#include <sys/param.h>
#include <net/if.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>



#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <syslog.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
#include <syslog.h>

#include <iostream>
#include "rl_str_proc.hh"
#include "rl_interface.hh"

using namespace std;

bool
rl_interface::is_configured(const std::string &interface, std::string &address)
{
  char hwaddr[32];
  
  if (interface.empty() == true) {
    //  printf("FAILURE:\n");
    return false;
  }
  
  struct ifreq ifr;
  int fd;
  const char *ifname = interface.c_str();
  
  fd = socket(AF_INET, SOCK_STREAM, 0);
  
  if (fd < 0) {
    fprintf(stderr, "Warning: no inet socket available: %s\n",
	    strerror(errno));
    //    printf("FAILURE:\n");
    return (false);
  }
  
  strncpy(ifr.ifr_name, ifname, IFNAMSIZ);
  
  if (ioctl(fd, SIOCGIFHWADDR, &ifr) < 0)
    memset(hwaddr, 0, 32);
  else
    memcpy(hwaddr, ifr.ifr_hwaddr.sa_data, 8);
  strncpy(ifr.ifr_name, ifname, IFNAMSIZ);
  if (ioctl(fd, SIOCGIFADDR, &ifr) == 0) {
    struct sockaddr_in addr;
    addr.sin_addr = ((struct sockaddr_in*)&ifr.ifr_addr)->sin_addr;
    address = string(inet_ntoa(addr.sin_addr));

    strncpy(ifr.ifr_name, ifname, IFNAMSIZ);
    if (ioctl(fd, SIOCGIFNETMASK, &ifr) < 0) {
      address = string(ifr.ifr_addr.sa_data);
      //       printf("FAILURE: %d\n", ifr.ifr_netmask);
      return false;
      //      memset(&ife->netmask, 0, sizeof(struct sockaddr));
    }
    else {
      //      printf("SUCCESS: %d\n", ifr.ifr_netmask);
      //ife->netmask = ifr.ifr_netmask;
      return true;
    }
    
  } 
  
  //  printf("FAILURE: %d\n", ifr.ifr_netmask);
  return false;
}

/**
 * First check interfaces and retreive interface and device name.
 * Then apply device name to config to find card type--then
 * return card type.
 *
vyatta:~# cat /proc/net/wanrouter/interfaces
Interface name | Device name | Media | Operational State |
wan0           | wanpipe1    | 0     | Connecting        |
wan0ppp        | wan0        | 0     | Disconnected      |


vyatta:~# cat /proc/net/wanrouter/config
Device name | Protocol Map | Adapter  | IRQ | Slot/IO | If's | CLK | Baud rate |
wanpipe1    | N/A          | A101/2   | 9   | 20      | 1    | EXT | 0         |
 *
 *
 **/
string 
rl_interface::find_serial_card_type(const string &serial)
{
  string card_type = "sangoma-t1/e1";
  string device;

  string cmd = "cat /proc/net/wanrouter/interfaces";
  char line[513];
  
  FILE *f = popen(cmd.c_str(), "r");
  if (f) {
    while (fgets(line, 512, f) != 0) {
      string output(line);
      string tmp_serial = serial + " "; //add a space for an exact match
      StrProc proc(output, " ");
      //      cout << "line (interfaces): " << serial << ", " << output << endl;
      if (output.find(tmp_serial) != string::npos) {
	device = proc.get(2);
	//	cout << "device: " << device << endl;
	break;
      }
    }
    fclose(f);
  }

  cmd = "cat /proc/net/wanrouter/config";
  f = popen(cmd.c_str(), "r");
  if (f) {
    while (fgets(line, 512, f) != 0) {
      string output(line);
      StrProc proc(output, " ");
      //      cout << "line (config): " << output << endl;
      if (proc.get(0) == device) {
	if (proc.get(4).find("A30") != string::npos) {
	  card_type = "sangoma-t3";
	  break;
	}
      }
    }
    fclose(f);
  }
  return card_type;
}
