/*
 * Module: rl_fw.hh
 *
 * **** License ****
 * Version: VPL 1.0
 *
 * The contents of this file are subject to the Vyatta Public License
 * Version 1.0 ("License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.vyatta.com/vpl
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * This code was originally developed by Vyatta, Inc.
 * Portions created by Vyatta are Copyright (C) 2006, 2007 Vyatta, Inc.
 * All Rights Reserved.
 *
 * Author: Michael Larson
 * Date: 2006
 * Description:
 *
 * **** End License ****
 *
 */

#ifndef __RL_FW_HH__
#define __RL_FW_HH__


#include <map>
#include <vector>
#include <set>
#include <string>
#include <libxipc/xrl_error.hh>
#include <libxorp/ipv4.hh>
#include <libxorp/ipv4net.hh>
#include "rl_nat.hh"

/**
 *
 **/
class FWData 
{
public:
  FWData();
  ~FWData();

  XrlCmdError
  get_iptables_cmds(const string &name, uint32_t ct, vector<string> &coll);

  uint32_t
  get_chain_ct();

public:
  string _protocol;
  string _icmp_type;
  string _icmp_code;

  bool _established_state;
  bool _new_state;
  bool _related_state;
  bool _invalid_state;
  string _action;
  string _log;
  uint32_t _rate_limit;
  string _rate_interval;
  uint32_t _rate_limit_burst;
  
  IPv4 _source_address;
  rlIPv4Net _source_network;
  IPv4 _source_address_start;
  IPv4 _source_address_stop;
  uint32_t _source_port_number;
  string _source_port_name;
  uint32_t _source_port_start;
  uint32_t _source_port_stop;
  
  IPv4 _dest_address;
  rlIPv4Net _dest_network;
  IPv4 _dest_address_start;
  IPv4 _dest_address_stop;
  uint32_t _dest_port_number;
  string _dest_port_name;
  uint32_t _dest_port_start;
  uint32_t _dest_port_stop;

  //flags used to determine is there are active rules
  bool _active_rule;
  bool _active_log_rule;


  bool _changed; //used to identify an updated/new/changed rule
};

/**
 *
 **/
class FWChain
{
public:
  typedef map<uint32_t, FWData> FirewallColl;
  typedef map<uint32_t, FWData>::iterator FirewallIter;

public:
  FWChain();
  ~FWChain() {}

  FirewallColl
  expose();

  bool
  is_empty();

  FWData
  get(int &rule_number);

  XrlCmdError
  remove(const string &name, uint32_t rule_number, vector<string> &coll);

  XrlCmdError
  get_iptables_cmds(const string &name, uint32_t rule_number, vector<string> &coll);

  void 
  set_protocol(const string protocol, uint32_t rule_number);

  void
  set_icmp_type(const string type, uint32_t rule_number);

  void
  set_icmp_code(const string code, uint32_t rule_number);

  void
  set_state_established(bool state, uint32_t rule_number);

  void
  set_state_new(bool state, uint32_t rule_number);

  void
  set_state_related(bool state, uint32_t rule_number);

  void
  set_state_invalid(bool state, uint32_t rule_number);

  void
  set_action(const string action, uint32_t rule_number);

  void
  set_rule_log(const string log, uint32_t rule_number);

  void
  set_source_address(const IPv4 address, uint32_t rule_number);

  void
  set_source_network(const IPv4Net network, uint32_t rule_number);

  void
  set_source_address(const IPv4 start, const IPv4 stop, uint32_t rule_number);

  void
  set_source_port_number(const uint32_t port_number, uint32_t rule_number);

  void
  set_source_port_name(const string port_name, uint32_t rule_number);

  void
  set_source_port(uint32_t start, uint32_t stop, uint32_t rule_number);

  void
  set_dest_address(const IPv4 address, uint32_t rule_number);

  void
  set_dest_network(const IPv4Net network, uint32_t rule_number);

  void
  set_dest_address(const IPv4 start, const IPv4 stop, uint32_t rule_number);

  void
  set_dest_port_number(const uint32_t port_number, uint32_t rule_number);

  void
  set_dest_port_name(const string port_name, uint32_t rule_number);

  void
  set_dest_port(uint32_t start, uint32_t stop, uint32_t rule_number);

private:
  void
  load_cur(uint32_t rule_number);

private:
  FirewallColl _fw_chain;
};



#endif //__RL_FW_HH__
