/*
 * Module: rl_fileaccess.hh
 *
 * **** License ****
 * Version: VPL 1.0
 *
 * The contents of this file are subject to the Vyatta Public License
 * Version 1.0 ("License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.vyatta.com/vpl
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * This code was originally developed by Vyatta, Inc.
 * Portions created by Vyatta are Copyright (C) 2005, 2006, 2007 Vyatta, Inc.
 * All Rights Reserved.
 *
 * Author: Michael Larson
 * Date: 2005
 * Description:
 *
 * **** End License ****
 *
 */

#ifndef __RL_SYSTEM_FILEACCESS_HH__
#define __RL_SYSTEM_FILEACCESS_HH__

#include <string>

class rl_fileaccess
{
public:
  rl_fileaccess(const std::string &in_filename, const std::string &out_filename);
  rl_fileaccess(const std::string &filename);
  ~rl_fileaccess();

  static void
  init(const std::string &filename);

  bool
  get(FILE*& rd_fd, FILE*& wr_fd);

private:
  std::string _in_filename;
  std::string _out_filename;
  static int MAX_FILENAME_LENGTH;
  int _fd_write;
  FILE* _fd_writestream;
  FILE* _fd_readstream;
};

#endif //__RL_SYSTEM_FILEACCESS_HH__
