/*
 * Module: rl_command.hh
 *
 * **** License ****
 * Version: VPL 1.0
 *
 * The contents of this file are subject to the Vyatta Public License
 * Version 1.0 ("License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.vyatta.com/vpl
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * This code was originally developed by Vyatta, Inc.
 * Portions created by Vyatta are Copyright (C) 2005, 2006, 2007 Vyatta, Inc.
 * All Rights Reserved.
 *
 * Author: Michael Larson
 * Date: 2005
 * Description:
 *
 * **** End License ****
 *
 */

#ifndef __RL_SYSTEM_COMMAND_HH__
#define __RL_SYSTEM_COMMAND_HH__

#include <string>
#include <vector>

#define RL_TRACE rl_trace t(__PRETTY_FUNCTION__);

#define	IPTABLES_PATH	SBINDIR

class rl_command
{
public:
    rl_command() {}
    ~rl_command() {}

  static bool
  execute(const std::string &cmd, bool debug = false, bool log = true);

};

class rl_trace
{
public:
    rl_trace(const std::string &module);
    ~rl_trace();
    
private:
  std::string _module;
};

class rl_utils
{
public:
  static std::string
  to_upper(const std::string &str);

  static bool
  find_process(const std::string &proc);

  static bool
  is_boot_rw();

  unsigned long long
  rdtsc();


  static void
  tokenize(const std::string& str,
	   std::vector<std::string>& tokens,
	   const std::string& delimiters);
};

#endif //__RL_SYSTEM_COMMAND_HH__
