#ifndef __IFMGR_XRL_IFMGR_MIRROR_TARGET_HH__
#define __IFMGR_XRL_IFMGR_MIRROR_TARGET_HH__

#include "libxipc/xrl_router.hh"
#include "ifmgr_cmd_queue.hh"
#include "xrl/targets/fea_ifmgr_mirror_base.hh"
#include "ifmgr_atoms.hh"
#include "ifmgr_cmd_queue.hh"


// ----------------------------------------------------------------------------
// IfMgrXrlMirrorTarget
//
// Class that receives Xrls from Fea IfMgr and converts them into commands
// to be dispatched on IfMgrIfTree.
//
// NB All method definitions are external to class declaration in case
// we later decide to move the declaration to a header.
//

class IfMgrHintObserver;

class IfMgrXrlMirrorTarget : protected XrlFeaIfmgrMirrorTargetBase {
public:
    IfMgrXrlMirrorTarget(XrlRouter& rtr, IfMgrCommandDispatcher& dispatcher);

    bool attach(IfMgrHintObserver* o);
    bool detach(IfMgrHintObserver* o);

public:
    XrlCmdError fea_ifmgr_mirror_nl_set_mtu(
	// Input values,
	const string&	ifname,
	const uint32_t&	mtu_bytes);

    XrlCmdError fea_ifmgr_mirror_nl_vif_set_enabled(
	// Input values,
	const string&	ifname,
	const string&	vifname,
	const bool&	enabled);

    XrlCmdError fea_ifmgr_mirror_nl_set_enabled(
	// Input values,
	const string&	ifname,
	const bool&	enabled);

    XrlCmdError fea_ifmgr_mirror_nl_set_mac(
	// Input values,
	const string&	ifname,
	const Mac&	mac);

    XrlCmdError fea_ifmgr_mirror_nl_add(
	// Input values,
	const string&	ifname);


  XrlCmdError fea_ifmgr_mirror_nl_set_link(
					   const string &ifname,
					   const bool   vif,
					   const uint32_t mtu,
					   const Mac &mac,
					   const bool enabled,
					   const uint32_t index);
    
    XrlCmdError fea_ifmgr_mirror_nl_set_prefix(
	// Input values,
	const string&	ifname,
	const bool      vif,
	uint32_t        index,
	const IPv4&	addr,
	const uint32_t&	prefix_len,
	const IPv4&     broadcast,
	const bool      enabled);

  //del_prefix
    XrlCmdError fea_ifmgr_mirror_nl_ipv4_remove(
	// Input values,
	const string&	ifname,
	const bool      vif,
	const IPv4&	addr);

  //del_link of some sort
    XrlCmdError fea_ifmgr_mirror_nl_interface_remove(
	// Input values,
	const string&	ifname,
	const bool      vif);

  IfMgrIfTree iftree() {return _dispatcher.iftree();}


protected:
    XrlCmdError common_0_1_get_target_name(
	// Output values,
	string& name);

    XrlCmdError common_0_1_get_version(
	// Output values,
	string& version);

    XrlCmdError common_0_1_get_status(
	// Output values,
	uint32_t& status,
	string& reason);

    XrlCmdError common_0_1_shutdown();

    XrlCmdError fea_ifmgr_mirror_0_1_hint_tree_complete();

    XrlCmdError fea_ifmgr_mirror_0_1_hint_updates_made();

protected:
    // Not implemented
    IfMgrXrlMirrorTarget();
    IfMgrXrlMirrorTarget(const IfMgrXrlMirrorTarget&);
    IfMgrXrlMirrorTarget& operator=(const IfMgrXrlMirrorTarget&);

protected:
    XrlRouter&		    _rtr;
    IfMgrCommandDispatcher& _dispatcher;
    IfMgrHintObserver*	    _hint_observer;
};

#endif //__IFMGR_XRL_IFMGR_MIRROR_TARGET_HH__
