#include "libxorp/status_codes.h"
#include "libxorp/eventloop.hh"

#include "libxipc/xrl_std_router.hh"
#include "xrl/interfaces/fea_ifmgr_replicator_xif.hh"
#include "ifmgr_cmds.hh"
#include "ifmgr_xrl_observer.hh"
#include "ifmgr_xrl_mirror_target.hh"

// ----------------------------------------------------------------------------
// IfMgrXrlMirrorTarget implementation

static const char* DISPATCH_FAILED = "Local dispatch error";

IfMgrXrlMirrorTarget::IfMgrXrlMirrorTarget(XrlRouter&		 rtr,
					   IfMgrCommandDispatcher& dispatcher)
    : XrlFeaIfmgrMirrorTargetBase(&rtr), _rtr(rtr), _dispatcher(dispatcher),
      _hint_observer(0)
{
}

XrlCmdError
IfMgrXrlMirrorTarget::common_0_1_get_target_name(string& name)
{
    name = _rtr.instance_name();
    return XrlCmdError::OKAY();
}

XrlCmdError
IfMgrXrlMirrorTarget::common_0_1_get_version(string& version)
{
    version = "IfMgrMirror/0.1";
    return XrlCmdError::OKAY();
}

XrlCmdError
IfMgrXrlMirrorTarget::common_0_1_get_status(uint32_t& status,
					    string&   reason)
{
    // Nothing to do.  Expect container application will get this call
    // at the appropriate level.
    status = uint32_t(PROC_READY);
    reason.erase();

    return XrlCmdError::OKAY();
}

XrlCmdError
IfMgrXrlMirrorTarget::common_0_1_shutdown()
{
    // Nothing to do.  Expect container application will get this call
    // at the appropriate level.
    return XrlCmdError::OKAY();
}

XrlCmdError
IfMgrXrlMirrorTarget::fea_ifmgr_mirror_nl_interface_remove(
							   const string& ifname,
							   const bool    vif
							   )
{
  XLOG_INFO("fea_ifmgr_mirror_nl_interface_remove: %s", ifname.c_str());
  _dispatcher.push(new IfMgrIfSetEnabled(ifname, false));
  if (_dispatcher.execute() == false) {
    return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
  }

  if (vif) {
    _dispatcher.push(new IfMgrIfRemove(ifname));
    if (_dispatcher.execute() == false) {
      return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
    }
  }
  else {
    _dispatcher.push(new IfMgrVifRemove(ifname, ifname));
    if (_dispatcher.execute() == false) {
      return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
    }
  }
  _dispatcher.push(new IfMgrHintTreeComplete());
  if (_dispatcher.execute() == false) {
    return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
  }
  fea_ifmgr_mirror_0_1_hint_updates_made();
  return XrlCmdError::OKAY();
}

XrlCmdError
IfMgrXrlMirrorTarget::fea_ifmgr_mirror_nl_ipv4_remove(
	const string&	ifname,
	const bool      vif,
	const IPv4&	addr
)
{
  UNUSED(vif);
  XLOG_INFO("fea_ifmgr_mirror_nl_ipv4_remove: %s, %s", ifname.c_str(), addr.str().c_str());

  _dispatcher.push(new IfMgrIPv4Remove(ifname, ifname, addr));
  if (_dispatcher.execute() == false) {
    return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
  }
  _dispatcher.push(new IfMgrHintTreeComplete());
  if (_dispatcher.execute() == false) {
    return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
  }
  fea_ifmgr_mirror_0_1_hint_updates_made();
  return XrlCmdError::OKAY();
}

XrlCmdError
IfMgrXrlMirrorTarget::fea_ifmgr_mirror_nl_set_link(
						   const string &ifname,
						   const bool   vif,
						   const uint32_t mtu,
						   const Mac &mac,
						   const bool enabled,
						   const uint32_t index)
{
  UNUSED(vif);  
  XLOG_INFO("fea_ifmgr_mirror_nl_set_link: %s, enabled: %s", ifname.c_str(), string(enabled ? "true" : "false").c_str());
  _dispatcher.push(new IfMgrIfAdd(ifname));
  if (_dispatcher.execute() == false) {
    return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
  }

  _dispatcher.push(new IfMgrIfSetEnabled(ifname, enabled));
  if (_dispatcher.execute() == false) {
    return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
  }

  _dispatcher.push(new IfMgrIfSetMtu(ifname, mtu));
  if (_dispatcher.execute() == false) {
    return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
  }
  
  _dispatcher.push(new IfMgrIfSetMac(ifname, mac));
  if (_dispatcher.execute() == false) {
    return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
  }

  _dispatcher.push(new IfMgrIfSetPifIndex(ifname, index));
  if (_dispatcher.execute() == false) {
    return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
  }
  
  _dispatcher.push(new IfMgrIfSetNoCarrier(ifname, false));
  if (_dispatcher.execute() == false) {
    return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
  }

  _dispatcher.push(new IfMgrVifAdd(ifname, ifname));
  if (_dispatcher.execute() == false) {
    return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
  }

  _dispatcher.push(new IfMgrVifSetEnabled(ifname, ifname, enabled));
  if (_dispatcher.execute() == false) {
    return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
  }
  /*
    _dispatcher.push(new IfMgrVifSetP2PCapable(ifname, ifname, cap));
    if (_dispatcher.execute() == false) {
    return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
    }
  */
  _dispatcher.push(new IfMgrVifSetLoopbackCapable(ifname, ifname, ifname == "lo" ? true:false));
  if (_dispatcher.execute() == false) {
    return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
  }
  
  _dispatcher.push(new IfMgrVifSetPifIndex(ifname, ifname, index));
  if (_dispatcher.execute() == false) {
    return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
  }

  _dispatcher.push(new IfMgrHintTreeComplete());
  if (_dispatcher.execute() == false) {
    return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
  }
  fea_ifmgr_mirror_0_1_hint_updates_made();
  return XrlCmdError::OKAY();
}
						   

XrlCmdError
IfMgrXrlMirrorTarget::fea_ifmgr_mirror_nl_set_prefix(
	const string&	ifname,
	const bool      vif,
	uint32_t        index,
	const IPv4&	addr,
	const uint32_t& prefix_len,
	const IPv4&     broadcast,
	const bool      enabled
)
{
  UNUSED(vif);
  UNUSED(enabled);
  XLOG_INFO("fea_ifmgr_mirror_nl_set_prefix: %s, %s/%d", ifname.c_str(), addr.str().c_str(), prefix_len);

  _dispatcher.push(new IfMgrIPv4Add(ifname, ifname, addr));
  if (_dispatcher.execute() == false) {
    return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
  }
  
  _dispatcher.push(new IfMgrIPv4SetEnabled(ifname, ifname, addr, true));
  if (_dispatcher.execute() == false) {
    return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
  }
  
  _dispatcher.push(new IfMgrIPv4SetLoopback(ifname, ifname, addr, ifname == "lo" ? true:false)); //todo: better check needed here
  if (_dispatcher.execute() == false) {
    return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
  }
    
  _dispatcher.push(new IfMgrIPv4SetMulticastCapable(ifname, ifname, addr, true)); //todo: see if this is set via the interface...
  if (_dispatcher.execute() == false) {
    return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
  }
  
  _dispatcher.push(new IfMgrIPv4SetPrefix(ifname, ifname, addr, prefix_len));
  if (_dispatcher.execute() == false) {
    return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
  }
  /*
  _dispatcher.push(new IfMgrIPv4SetEnabled(ifname, ifname, addr, true));
  if (_dispatcher.execute() == false) {
    return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
  }
  */
  _dispatcher.push(new IfMgrIPv4SetBroadcast(ifname, ifname, addr, broadcast));
  if (_dispatcher.execute() == false) {
    return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
  }

  //leaving out setendpoint for now...
  //IfMgrVifAdd??
  //now vif--should always be "on"

  if (vif) {
    _dispatcher.push(new IfMgrVifAdd(ifname, ifname));
    if (_dispatcher.execute() == false) {
      return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
    }
    //IfMgrVifSetEnabled??
    _dispatcher.push(new IfMgrVifSetEnabled(ifname, ifname, true));
    if (_dispatcher.execute() == false) {
      return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
    }
    //IfMgrVifSetMulticastCapable
    _dispatcher.push(new IfMgrVifSetMulticastCapable(ifname, ifname, true));
    if (_dispatcher.execute() == false) {
      return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
    }
    //IfMgrVifSetBroadcastCapable
    _dispatcher.push(new IfMgrVifSetBroadcastCapable(ifname, ifname, true));
    if (_dispatcher.execute() == false) {
      return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
    }
    //IfMgrVifSetLoopbackCapable
    _dispatcher.push(new IfMgrVifSetLoopbackCapable(ifname, ifname, true));
    if (_dispatcher.execute() == false) {
      return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
    }
    _dispatcher.push(new IfMgrVifSetPifIndex(ifname, ifname, index));
    if (_dispatcher.execute() == true) {
	return XrlCmdError::OKAY();
    }

  }
  _dispatcher.push(new IfMgrHintTreeComplete());
  if (_dispatcher.execute() == false) {
    return XrlCmdError::COMMAND_FAILED(DISPATCH_FAILED);
  }
  fea_ifmgr_mirror_0_1_hint_updates_made();
  return XrlCmdError::OKAY();
}

bool
IfMgrXrlMirrorTarget::attach(IfMgrHintObserver* ho)
{
    if (_hint_observer != 0) {
	return false;
    }
    _hint_observer = ho;
    return true;
}

bool
IfMgrXrlMirrorTarget::detach(IfMgrHintObserver* ho)
{
    if (_hint_observer != ho) {
	return false;
    }
    _hint_observer = 0;
    return true;
}

XrlCmdError
IfMgrXrlMirrorTarget::fea_ifmgr_mirror_0_1_hint_tree_complete()
{
    if (_hint_observer)
	_hint_observer->tree_complete();
    return XrlCmdError::OKAY();
}

XrlCmdError
IfMgrXrlMirrorTarget::fea_ifmgr_mirror_0_1_hint_updates_made()
{
    if (_hint_observer)
	_hint_observer->updates_made();
    return XrlCmdError::OKAY();
}

