/*
** test_netlink.cc
** Login : <mike@phuket.vyatta.com>
** Started on  Thu Jul 13 15:39:57 2006 Mike Larson
** $Id$
** 
** Copyright (C) 2006 Mike Larson
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include <iostream>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <asm/types.h>
#include <linux/if_ether.h>
#include <linux/rtnetlink.h>

#include <sys/ioctl.h>
#include <sys/param.h>
#include <net/if.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>


//to compile:
//g++ -g test_netlink.cc -o test_netlink


void
dump(const char *name, const void *_s, size_t len)
{
    unsigned char *s = (unsigned char *)_s;
    int i;

    printf("%s:\n", name);
    for(i=0; i<len; ++i) {
	    if((i%4)==0)
		    printf("\n");

	    printf("0x%02x ", s[i]);
    }
    printf("\n");
}

int main(int argc, char* argv[])
{
  struct sockaddr_nl	snl;
  struct nlmsghdr*	nlh;
  struct ifinfomsg*	ifinfomsg;
  char ether_addr[6] = {0x00,0x01,0x02,0x03,0x04,0x05};
  
  if (argc < 2) {
    printf("usage: test_netlink [devname]\n");
    printf("will set device to the mac address: 00:01:02:03:04:05\n");
    exit(1);
  }

  int if_index = if_nametoindex(argv[1]);
  if (if_index <= 0) {
    printf("if_index==%d\n", if_index);
    exit(1);
  }
  
  int fd = socket(AF_NETLINK, SOCK_RAW, NETLINK_ROUTE);
  if (fd < 0) {
    perror("socket");
    exit(1);
  }
  //    comm_sock_set_rcvbuf(fd, SO_RCV_BUF_SIZE_MAX, SO_RCV_BUF_SIZE_MIN);
    
    // TODO: do we want to make the socket non-blocking?
    
    //
    // Bind the socket
    //
    memset(&snl, 0, sizeof(snl));
    snl.nl_family = AF_NETLINK;
    snl.nl_pid    = 0;		// Let the kernel assign the pid to the socket
    snl.nl_groups = 0;
    if (bind(fd, reinterpret_cast<struct sockaddr*>(&snl), sizeof(snl)) < 0) {
	close(fd);
	exit(1);
    }
    

    static const size_t	buffer_size = sizeof(struct nlmsghdr)
	+ sizeof(struct ifinfomsg) + 2*sizeof(struct rtattr) + 512;
    uint8_t		buffer[buffer_size];
    struct rtattr*	rtattr;
    int			rta_len;

    memset(buffer, 0x69, sizeof(buffer));

    // Set the socket
    memset(&snl, 0, sizeof(snl));
    snl.nl_family = AF_NETLINK;
    snl.nl_pid    = 0;		// nl_pid = 0 if destination is the kernel
    snl.nl_groups = 0;

    //
    // Set the request
    //
    nlh = reinterpret_cast<struct nlmsghdr*>(buffer);
    nlh->nlmsg_len = NLMSG_LENGTH(sizeof(*ifinfomsg));
    nlh->nlmsg_type = RTM_SETLINK;
    nlh->nlmsg_flags = NLM_F_REQUEST | NLM_F_CREATE | NLM_F_REPLACE | NLM_F_ACK;
    nlh->nlmsg_seq = 0;//ns.seqno();
    nlh->nlmsg_pid = 0;//ns.nl_pid();

    dump("nlh", nlh, sizeof *nlh);

    ifinfomsg = reinterpret_cast<struct ifinfomsg*>(NLMSG_DATA(nlh));
    ifinfomsg->ifi_family = AF_UNSPEC;
    ifinfomsg->ifi_type = IFLA_UNSPEC;	// TODO: set to ARPHRD_ETHER ??
    ifinfomsg->ifi_index = if_index; //if_index; //this probably needs to be
			      //an argument!
    ifinfomsg->ifi_flags = 0;
    ifinfomsg->ifi_change = 0xffffffff;
    dump("ifinfomsg", ifinfomsg, sizeof *ifinfomsg);

    // Add the MAC address as an attribute
    rtattr = IFLA_RTA(ifinfomsg);
    rtattr->rta_type = IFLA_ADDRESS;

    {
	struct sockaddr	*mac_sockaddr_p = (struct sockaddr *)RTA_DATA(rtattr);

	rta_len = RTA_LENGTH(ETH_ALEN);
	if(NLMSG_ALIGN(nlh->nlmsg_len)+rta_len > sizeof(buffer))
		exit(1);

	mac_sockaddr_p->sa_family = AF_UNSPEC;
	memcpy(&mac_sockaddr_p->sa_data, &ether_addr, ETH_ALEN);
	rtattr->rta_len = rta_len;
	nlh->nlmsg_len = NLMSG_ALIGN(nlh->nlmsg_len) + sizeof mac_sockaddr_p->sa_family + rta_len;
    }

    dump("sendto",buffer, nlh->nlmsg_len);

    if (sendto(fd, buffer, nlh->nlmsg_len, 0,
		  reinterpret_cast<struct sockaddr*>(&snl), sizeof(snl))
	!= (ssize_t)nlh->nlmsg_len) {
	perror("sendto");
	exit(1);
    }
  return 0;
}
