/* -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*- */
/*
 * Module: tcpmd5.c
 *
 * **** License ****
 * Version: VPL 1.0
 *
 * The contents of this file are subject to the Vyatta Public License
 * Version 1.0 ("License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.vyatta.com/vpl
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * This code was originally developed by Vyatta, Inc.
 * Portions created by Vyatta are Copyright (C) "YEAR" Vyatta, Inc.
 * All Rights Reserved.
 *
 * Author: Tom Grennan
 * Date: 2007
 * Description: non-linux setsockopt() for TCP_MD5SIG
 *
 * **** End License ****
 *
 */
#include <string.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include "tcpmd5.h"

/*
 * If TCP_MD5SIG is undefined, our compile system headers may just be
 * out of date with the target kernel. We recreate the BSD definitions
 * as the worst that may happen is an ENOPROTOOPT.
 */
#if !defined(TCP_MD5SIG)
#  define TCP_MD5SIG 0x10 
#endif

#define FIXME 0
#if !defined(UNUSED)
#  define UNUSED(arg)	switch (sizeof(arg)) { case (0): case (arg) }
#endif

int
setsockopt_tcpmd5(int sock,
		  const struct sockaddr *saddr,
		  size_t slen,
		  const char *key)
{
#if FIXME
    UNUSED(saddr);
    UNUSED(slen);
    /* BSD needs something like... */
    char cmd[128];
    if (strlen(key) > 80)
	return -1;
    sprintf(cmd, "setkey -4 add SRC DST tcp 0x1000 -A tcp-md5 %s", key);
    system(cmd);
#endif
    return setsockopt(sock, IPPROTO_TCP, TCP_MD5SIG,
		      (key && *key) ? key : NULL,
		      sizeof(int));
}
