// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-
// vim:set sts=4 ts=8:


// $XORP$

#ifndef __BGP_ROUTE_TABLE_DUPFILT_HH__
#define __BGP_ROUTE_TABLE_DUPFILT_HH__

#include <map>
#include "route_table_base.hh"
#include "peer_route_pair.hh"
#include "route_queue.hh"
#include "crash_dump.hh"



template<class A>
class DupfiltRouteQueueEntry : public RouteQueueEntry<A> {
public:
    DupfiltRouteQueueEntry(const SubnetRoute<A> *rt, RouteQueueOp op) :
    RouteQueueEntry<A>(rt, op) {
        _hash_prev = NULL;
        _hash_next = NULL;
        _queue_prev = NULL;
        _queue_next = NULL;
    }

    // for push only
    DupfiltRouteQueueEntry(RouteQueueOp op, const PeerHandler *origin_peer) :
    RouteQueueEntry<A>(op, origin_peer) {
        _hash_prev = NULL;
        _hash_next = NULL;
        _queue_prev = NULL;
        _queue_next = NULL;
    }

    DupfiltRouteQueueEntry<A> *hash_prev() { return _hash_prev; }
    DupfiltRouteQueueEntry<A> *hash_next() { return _hash_next; }
    void set_hash_prev(DupfiltRouteQueueEntry<A> *prev)
    {
        _hash_prev = prev;
    }
    void set_hash_next(DupfiltRouteQueueEntry<A> *next)
    {
        _hash_next = next;
    }

    DupfiltRouteQueueEntry<A> *queue_prev() { return _queue_prev; }
    DupfiltRouteQueueEntry<A> *queue_next() { return _queue_next; }
    void set_queue_prev(DupfiltRouteQueueEntry<A> *prev)
    {
        _queue_prev = prev;
    }
    void set_queue_next(DupfiltRouteQueueEntry<A> *next)
    {
        _queue_next = next;
    }
private:
    DupfiltRouteQueueEntry<A> *_hash_prev;
    DupfiltRouteQueueEntry<A> *_hash_next;
    DupfiltRouteQueueEntry<A> *_queue_prev;
    DupfiltRouteQueueEntry<A> *_queue_next;

};



#define DUPFILT_HASH_BITS 19
#define DUPFILT_HASH_MASK 0x7ffff

#define DUPFILT_HASH_SIZE (1 << DUPFILT_HASH_BITS)
#define DUPFILT_HASH(key) (((((unsigned int)key) >> DUPFILT_HASH_BITS) ^ \
			   ((unsigned int)key)) & DUPFILT_HASH_MASK)

template<class A>
class DupfiltTable : public BGPRouteTable<A>  {
public:
    DupfiltTable(string tablename,
		Safi safi,
		 BGPRouteTable<A> *init_parent);
    ~DupfiltTable();

    int delete_route(const InternalMessage<A> &rtmsg, 
		     BGPRouteTable<A> *caller);

    int add_route(const InternalMessage<A> &rtmsg,
		  BGPRouteTable<A> *caller);

    int replace_route(const InternalMessage<A> &old_rtmsg,
		      const InternalMessage<A> &new_rtmsg,
		      BGPRouteTable<A> *caller);

    int route_dump(const InternalMessage<A> &rtmsg,
		   BGPRouteTable<A> *caller,
		   const PeerHandler *dump_peer);

    int push(BGPRouteTable<A> *caller);
    const SubnetRoute<A> *lookup_route(const IPNet<A> &net,
				       uint32_t& genid) const;

    RouteTableType type() const {return DUPFILT_TABLE;}
    string str() const;

    /* mechanisms to implement flow control in the output plumbing */
    bool get_next_message(BGPRouteTable<A> *next_table);


private:

    void add_to_queue(RouteQueueOp operation,
		      const InternalMessage<A> &rtmsg);
    void add_push_to_queue();
    DupfiltRouteQueueEntry<A> *hash_find_match(const InternalMessage<A> &rtmsg);
    void hash_list_insert(DupfiltRouteQueueEntry<A> *entry);

    void hash_list_del(DupfiltRouteQueueEntry<A> *entry);

    void output_queue_push(DupfiltRouteQueueEntry<A> *entry);
    DupfiltRouteQueueEntry<A> *output_queue_pop();
    void output_queue_del(DupfiltRouteQueueEntry<A> *entry);
    void do_wakeup();

    void debug_call_counts();
    void debug_queue_counts();

    DupfiltRouteQueueEntry<A> *_output_queue_head;
    DupfiltRouteQueueEntry<A> *_output_queue_tail;
    DupfiltRouteQueueEntry<A> *_hash[DUPFILT_HASH_SIZE];

    // Statistics
    int _queue_add_count;	// messages added to queue
    int _queue_del_count;	// messages deleted from queue
    int _queue_count;		// current queue count
    int _stats_print_rate;	// queue count interval at which to print stats
				// set to zero to disable stats printing

    int _add_route_count;	// number of add_route() calls
    int _replace_route_count;	// number of replace_route() calls
    int _delete_route_count;	// number of delete_route() calls
    int _route_dump_count;	// number of route_dump() calls
    int _push_count;		// number of push() calls
    int _queue_empty_count;	// times get_next_message() finds nothing
    int _hash_del_count;	// messages deleted because of hash match
    int _pull_del_count;	// messages deleted because of pull
    int _wakeup_calls;		// times we called next_table->wakeup()
};

#endif // __BGP_ROUTE_TABLE_DUPFILT_HH__
