// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-

// Copyright (c) 2007 Vyatta Inc.
//

// $Id$

#ifndef __BGP_ROUTE_DUMP_RECORD_HH__
#define __BGP_ROUTE_DUMP_RECORD_HH__

#define RT_REC_MAX_DATA 1024

template <typename A>
struct RouteDumpRecord {
	typedef typename A::InAddrType InAddrType;

	uint32_t _peer_id;
	struct {
	    InAddrType masked_addr;
	    uint32_t prefix_len;
	} _net;
	uint8_t _best;
	bool _unicast;
	bool _multicast;
	uint32_t _origin;
	InAddrType _nexthop;
	int32_t _med;
	int32_t _localpref;
	int32_t _atomic_agg;
	int32_t _calc_localpref;
	uint32_t _aspath_size;
	uint32_t _aggregator_size;
	uint32_t _community_size;
	uint32_t _attr_unknown_size;
	uint32_t _last_record;
};

#endif // __BGP_ROUTE_DUMP_RECORD_HH__
