/*
 * Copyright (c) 2001-2009 XORP, Inc.
 * See the XORP LICENSE.lgpl file for licensing, conditions, and warranties
 * on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'tgt-gen'.
 *
 * $XORP: xorp/xrl/targets/vrrp_base.hh,v 1.3 2009/01/05 18:31:15 jtc Exp $
 */


#ifndef __XRL_TARGETS_VRRP_BASE_HH__
#define __XRL_TARGETS_VRRP_BASE_HH__

#undef XORP_LIBRARY_NAME
#define XORP_LIBRARY_NAME "XrlVrrpTarget"

#include "libxorp/xlog.h"
#include "libxipc/xrl_cmd_map.hh"

class XrlVrrpTargetBase {
protected:
    XrlCmdMap* _cmds;

public:
    /**
     * Constructor.
     *
     * @param cmds an XrlCmdMap that the commands associated with the target
     *		   should be added to.  This is typically the XrlRouter
     *		   associated with the target.
     */
    XrlVrrpTargetBase(XrlCmdMap* cmds = 0);

    /**
     * Destructor.
     *
     * Dissociates instance commands from command map.
     */
    virtual ~XrlVrrpTargetBase();

    /**
     * Set command map.
     *
     * @param cmds pointer to command map to associate commands with.  This
     * argument is typically a pointer to the XrlRouter associated with the
     * target.
     *
     * @return true on success, false if cmds is null or a command map has
     * already been supplied.
     */
    bool set_command_map(XrlCmdMap* cmds);

    /**
     * Get Xrl instance name associated with command map.
     */
    const string& name() const { return _cmds->name(); }

    /**
     * Get version string of instance.
     */
    const char* version() const { return "vrrp/0.0"; }

protected:

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Get name of Xrl Target
     */
    virtual XrlCmdError common_0_1_get_target_name(
	// Output values,
	string&	name) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Get version string from Xrl Target
     */
    virtual XrlCmdError common_0_1_get_version(
	// Output values,
	string&	version) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Get status of Xrl Target
     */
    virtual XrlCmdError common_0_1_get_status(
	// Output values,
	uint32_t&	status,
	string&	reason) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Request clean shutdown of Xrl Target
     */
    virtual XrlCmdError common_0_1_shutdown() = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Create a VRRP instance.
     *
     *  @param ifname the interface name.
     *
     *  @param vifname the vif name.
     *
     *  @param vrid the VRRP router ID.
     */
    virtual XrlCmdError vrrp_0_1_add_vrid(
	// Input values,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	vrid) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Remove a VRRP instance.
     *
     *  @param ifname the interface name.
     *
     *  @param vifname the vif name.
     *
     *  @param vrid the VRRP router ID.
     */
    virtual XrlCmdError vrrp_0_1_delete_vrid(
	// Input values,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	vrid) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Set the router's priority.
     *
     *  @param ifname the interface on which VRRP is running.
     *
     *  @param vifname the vif on which VRRP is running.
     *
     *  @param vrid the VRRP router ID.
     *
     *  @param priority the new priority value.
     */
    virtual XrlCmdError vrrp_0_1_set_priority(
	// Input values,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	vrid,
	const uint32_t&	priority) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Set the advertisement interval.
     *
     *  @param ifname the interface on which VRRP is running.
     *
     *  @param vifname the vif on which VRRP is running.
     *
     *  @param vrid the VRRP router ID.
     *
     *  @param interval the new advertisement interval.
     */
    virtual XrlCmdError vrrp_0_1_set_interval(
	// Input values,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	vrid,
	const uint32_t&	interval) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Set whether a high priority backup router should preempt a low priority
     *  router that is acting as a master.
     *
     *  @param ifname the interface on which VRRP is running.
     *
     *  @param vifname the vif on which VRRP is running.
     *
     *  @param vrid the VRRP router ID.
     *
     *  @param preempt true if preemption should occur.
     */
    virtual XrlCmdError vrrp_0_1_set_preempt(
	// Input values,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	vrid,
	const bool&	preempt) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Start or stop a VRRP instance.
     *
     *  @param ifname the interface on which VRRP is running.
     *
     *  @param vifname the vif on which VRRP is running.
     *
     *  @param vrid the VRRP router ID.
     *
     *  @param disable if true, stop VRRP. Start it otherwise.
     */
    virtual XrlCmdError vrrp_0_1_set_disable(
	// Input values,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	vrid,
	const bool&	disable) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Add an IP to the virtual router.
     *
     *  @param ifname the interface on which VRRP is running.
     *
     *  @param vifname the vif on which VRRP is running.
     *
     *  @param vrid the VRRP router ID.
     *
     *  @param ip the IP address to add.
     */
    virtual XrlCmdError vrrp_0_1_add_ip(
	// Input values,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	vrid,
	const IPv4&	ip) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Remove an IP from the virtual router.
     *
     *  @param ifname the interface on which VRRP is running.
     *
     *  @param vifname the vif on which VRRP is running.
     *
     *  @param vrid the VRRP router ID.
     *
     *  @param ip the IP address to remove.
     */
    virtual XrlCmdError vrrp_0_1_delete_ip(
	// Input values,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	vrid,
	const IPv4&	ip) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Get the physical interfaces on which VRRP is running.
     *
     *  @param ifs a list of interface names (strings).
     */
    virtual XrlCmdError vrrp_0_1_get_ifs(
	// Output values,
	XrlAtomList&	ifs) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  For a given physical interface, get the virtual interfaces on which
     *  VRRP is running.
     *
     *  @param ifname the physical interface name.
     *
     *  @param vifs a list of virtual interface names (strings).
     */
    virtual XrlCmdError vrrp_0_1_get_vifs(
	// Input values,
	const string&	ifname,
	// Output values,
	XrlAtomList&	vifs) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Get the virtual router IDs of all the VRRP instances running on a
     *  network interface.
     *
     *  @param ifname the physical interface name.
     *
     *  @param vifname the logical interface name.
     *
     *  @param vrids a list of VRRP router IDs (integers).
     */
    virtual XrlCmdError vrrp_0_1_get_vrids(
	// Input values,
	const string&	ifname,
	const string&	vifname,
	// Output values,
	XrlAtomList&	vrids) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Get state information from a particular VRRP instance.
     *
     *  @param ifname the interface on which the VRRP instance is running.
     *
     *  @param vifname the vif on which the instance is running.
     *
     *  @param vrid the virtual router ID of the VRRP instance.
     *
     *  @param state the state of the router (initialize, master, backup).
     *
     *  @param master the IP address of the master. Only valid when running.
     */
    virtual XrlCmdError vrrp_0_1_get_vrid_info(
	// Input values,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	vrid,
	// Output values,
	string&	state,
	IPv4&	master) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Receive an IPv4 packet from a raw socket.
     *
     *  @param if_name the interface name the packet arrived on.
     *
     *  @param vif_name the vif name the packet arrived on.
     *
     *  @param src_address the IP source address.
     *
     *  @param dst_address the IP destination address.
     *
     *  @param ip_protocol the IP protocol number.
     *
     *  @param ip_ttl the IP TTL (hop-limit). If it has a negative value, then
     *  the received value is unknown.
     *
     *  @param ip_tos the Type of Service (Diffserv/ECN bits for IPv4). If it
     *  has a negative value, then the received value is unknown.
     *
     *  @param ip_router_alert if true, the IP Router Alert option was included
     *  in the IP packet.
     *
     *  @param ip_internet_control if true, then this is IP control traffic.
     *
     *  @param payload the payload, everything after the IP header and options.
     */
    virtual XrlCmdError raw_packet4_client_0_1_recv(
	// Input values,
	const string&	if_name,
	const string&	vif_name,
	const IPv4&	src_address,
	const IPv4&	dst_address,
	const uint32_t&	ip_protocol,
	const int32_t&	ip_ttl,
	const int32_t&	ip_tos,
	const bool&	ip_router_alert,
	const bool&	ip_internet_control,
	const vector<uint8_t>&	payload) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Receive a raw link-level packet on an interface.
     *
     *  @param if_name the interface name the packet arrived on.
     *
     *  @param vif_name the vif name the packet arrived on.
     *
     *  @param src_address the MAC source address.
     *
     *  @param dst_address the MAC destination address.
     *
     *  @param ether_type the EtherType protocol number or the Destination SAP.
     *  It must be between 1536 and 65535 to specify the EtherType, or between
     *  1 and 255 to specify the Destination SAP for IEEE 802.2 LLC frames.
     *
     *  @param payload the payload, everything after the MAC header.
     */
    virtual XrlCmdError raw_link_client_0_1_recv(
	// Input values,
	const string&	if_name,
	const string&	vif_name,
	const Mac&	src_address,
	const Mac&	dst_address,
	const uint32_t&	ether_type,
	const vector<uint8_t>&	payload) = 0;

private:
    const XrlCmdError handle_common_0_1_get_target_name(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_common_0_1_get_version(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_common_0_1_get_status(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_common_0_1_shutdown(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_vrrp_0_1_add_vrid(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_vrrp_0_1_delete_vrid(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_vrrp_0_1_set_priority(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_vrrp_0_1_set_interval(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_vrrp_0_1_set_preempt(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_vrrp_0_1_set_disable(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_vrrp_0_1_add_ip(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_vrrp_0_1_delete_ip(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_vrrp_0_1_get_ifs(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_vrrp_0_1_get_vifs(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_vrrp_0_1_get_vrids(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_vrrp_0_1_get_vrid_info(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_raw_packet4_client_0_1_recv(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_raw_link_client_0_1_recv(const XrlArgs& in, XrlArgs* out);

    void add_handlers();
    void remove_handlers();
};

#endif // __XRL_TARGETS_VRRP_BASE_HH__
