/*
 * Copyright (c) 2001-2009 XORP, Inc.
 * See the XORP LICENSE.lgpl file for licensing, conditions, and warranties
 * on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 *
 * $XORP: xorp/xrl/interfaces/fea_rawlink_client_xif.hh,v 1.9 2009/01/05 18:31:12 jtc Exp $
 */

#ifndef __XRL_INTERFACES_FEA_RAWLINK_CLIENT_XIF_HH__
#define __XRL_INTERFACES_FEA_RAWLINK_CLIENT_XIF_HH__

#undef XORP_LIBRARY_NAME
#define XORP_LIBRARY_NAME "XifFeaRawlinkClient"

#include "libxorp/xlog.h"
#include "libxorp/callback.hh"

#include "libxipc/xrl.hh"
#include "libxipc/xrl_error.hh"
#include "libxipc/xrl_sender.hh"


class XrlRawLinkClientV0p1Client {
public:
    XrlRawLinkClientV0p1Client(XrlSender* s) : _sender(s) {}
    virtual ~XrlRawLinkClientV0p1Client() {}

    typedef XorpCallback1<void, const XrlError&>::RefPtr RecvCB;
    /**
     *  Send Xrl intended to:
     *
     *  Receive a raw link-level packet on an interface.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param if_name the interface name the packet arrived on.
     *
     *  @param vif_name the vif name the packet arrived on.
     *
     *  @param src_address the MAC source address.
     *
     *  @param dst_address the MAC destination address.
     *
     *  @param ether_type the EtherType protocol number or the Destination SAP.
     *  It must be between 1536 and 65535 to specify the EtherType, or between
     *  1 and 255 to specify the Destination SAP for IEEE 802.2 LLC frames.
     *
     *  @param payload the payload, everything after the MAC header.
     */
    bool send_recv(
	const char*	dst_xrl_target_name,
	const string&	if_name,
	const string&	vif_name,
	const Mac&	src_address,
	const Mac&	dst_address,
	const uint32_t&	ether_type,
	const vector<uint8_t>&	payload,
	const RecvCB&	cb
    );

protected:
    XrlSender* _sender;

private:
    void unmarshall_recv(
	const XrlError&	e,
	XrlArgs*	a,
	RecvCB		cb
    );

};

#endif /* __XRL_INTERFACES_FEA_RAWLINK_CLIENT_XIF_HH__ */
