/*
 * Copyright (c) 2001-2009 XORP, Inc.
 * See the XORP LICENSE.lgpl file for licensing, conditions, and warranties
 * on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 *
 * $XORP: xorp/xrl/interfaces/fea_ifmgr_xif.hh,v 1.45 2009/01/05 18:31:12 jtc Exp $
 */

#ifndef __XRL_INTERFACES_FEA_IFMGR_XIF_HH__
#define __XRL_INTERFACES_FEA_IFMGR_XIF_HH__

#undef XORP_LIBRARY_NAME
#define XORP_LIBRARY_NAME "XifFeaIfmgr"

#include "libxorp/xlog.h"
#include "libxorp/callback.hh"

#include "libxipc/xrl.hh"
#include "libxipc/xrl_error.hh"
#include "libxipc/xrl_sender.hh"


class XrlIfmgrV0p1Client {
public:
    XrlIfmgrV0p1Client(XrlSender* s) : _sender(s) {}
    virtual ~XrlIfmgrV0p1Client() {}

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetRestoreOriginalConfigOnShutdownCB;

    bool send_set_restore_original_config_on_shutdown(
	const char*	dst_xrl_target_name,
	const bool&	enable,
	const SetRestoreOriginalConfigOnShutdownCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const XrlAtomList*>::RefPtr GetConfiguredInterfaceNamesCB;

    bool send_get_configured_interface_names(
	const char*	dst_xrl_target_name,
	const GetConfiguredInterfaceNamesCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const XrlAtomList*>::RefPtr GetConfiguredVifNamesCB;

    bool send_get_configured_vif_names(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const GetConfiguredVifNamesCB&	cb
    );

    typedef XorpCallback6<void, const XrlError&, const bool*, const bool*, const bool*, const bool*, const bool*>::RefPtr GetConfiguredVifFlagsCB;

    bool send_get_configured_vif_flags(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vif,
	const GetConfiguredVifFlagsCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr GetConfiguredVifPifIndexCB;

    bool send_get_configured_vif_pif_index(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vif,
	const GetConfiguredVifPifIndexCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const XrlAtomList*>::RefPtr GetConfiguredVifAddresses4CB;

    bool send_get_configured_vif_addresses4(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vif,
	const GetConfiguredVifAddresses4CB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const XrlAtomList*>::RefPtr GetConfiguredVifAddresses6CB;

    bool send_get_configured_vif_addresses6(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vif,
	const GetConfiguredVifAddresses6CB&	cb
    );

    typedef XorpCallback6<void, const XrlError&, const bool*, const bool*, const bool*, const bool*, const bool*>::RefPtr GetConfiguredAddressFlags4CB;

    bool send_get_configured_address_flags4(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	const GetConfiguredAddressFlags4CB&	cb
    );

    typedef XorpCallback5<void, const XrlError&, const bool*, const bool*, const bool*, const bool*>::RefPtr GetConfiguredAddressFlags6CB;

    bool send_get_configured_address_flags6(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	const GetConfiguredAddressFlags6CB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const bool*>::RefPtr GetConfiguredInterfaceEnabledCB;

    bool send_get_configured_interface_enabled(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const GetConfiguredInterfaceEnabledCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const bool*>::RefPtr GetConfiguredInterfaceDiscardCB;

    bool send_get_configured_interface_discard(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const GetConfiguredInterfaceDiscardCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const bool*>::RefPtr GetConfiguredInterfaceUnreachableCB;

    bool send_get_configured_interface_unreachable(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const GetConfiguredInterfaceUnreachableCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const bool*>::RefPtr GetConfiguredInterfaceManagementCB;

    bool send_get_configured_interface_management(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const GetConfiguredInterfaceManagementCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const Mac*>::RefPtr GetConfiguredMacCB;

    bool send_get_configured_mac(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const GetConfiguredMacCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr GetConfiguredMtuCB;

    bool send_get_configured_mtu(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const GetConfiguredMtuCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const bool*>::RefPtr GetConfiguredNoCarrierCB;

    bool send_get_configured_no_carrier(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const GetConfiguredNoCarrierCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint64_t*>::RefPtr GetConfiguredBaudrateCB;

    bool send_get_configured_baudrate(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const GetConfiguredBaudrateCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const bool*>::RefPtr GetConfiguredVifEnabledCB;

    bool send_get_configured_vif_enabled(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vif,
	const GetConfiguredVifEnabledCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr GetConfiguredPrefix4CB;

    bool send_get_configured_prefix4(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	const GetConfiguredPrefix4CB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const IPv4*>::RefPtr GetConfiguredBroadcast4CB;

    bool send_get_configured_broadcast4(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	const GetConfiguredBroadcast4CB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const IPv4*>::RefPtr GetConfiguredEndpoint4CB;

    bool send_get_configured_endpoint4(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	const GetConfiguredEndpoint4CB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr GetConfiguredPrefix6CB;

    bool send_get_configured_prefix6(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	const GetConfiguredPrefix6CB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const IPv6*>::RefPtr GetConfiguredEndpoint6CB;

    bool send_get_configured_endpoint6(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	const GetConfiguredEndpoint6CB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr StartTransactionCB;

    bool send_start_transaction(
	const char*	dst_xrl_target_name,
	const StartTransactionCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr CommitTransactionCB;

    bool send_commit_transaction(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const CommitTransactionCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AbortTransactionCB;

    bool send_abort_transaction(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const AbortTransactionCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr CreateInterfaceCB;

    bool send_create_interface(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const CreateInterfaceCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteInterfaceCB;

    bool send_delete_interface(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const DeleteInterfaceCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ConfigureAllInterfacesFromSystemCB;
    /**
     *  Send Xrl intended to:
     *
     *  Implicitly configure all interfaces within the FEA by using information
     *  from the underlying system.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param tid the transaction ID.
     *
     *  @param enable if true, then enable the implicit configuration,
     *  otherwise disable it.
     */
    bool send_configure_all_interfaces_from_system(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const bool&	enable,
	const ConfigureAllInterfacesFromSystemCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ConfigureInterfaceFromSystemCB;
    /**
     *  Send Xrl intended to:
     *
     *  Implicitly configure an interface within the FEA by using information
     *  from the underlying system.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param tid the transaction ID.
     *
     *  @param ifname the name of the interface to configure.
     *
     *  @param enable if true, then enable the implicit configuration,
     *  otherwise disable it.
     */
    bool send_configure_interface_from_system(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const bool&	enable,
	const ConfigureInterfaceFromSystemCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetInterfaceEnabledCB;

    bool send_set_interface_enabled(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const bool&	enabled,
	const SetInterfaceEnabledCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetInterfaceDiscardCB;

    bool send_set_interface_discard(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const bool&	discard,
	const SetInterfaceDiscardCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetInterfaceUnreachableCB;

    bool send_set_interface_unreachable(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const bool&	unreachable,
	const SetInterfaceUnreachableCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetInterfaceManagementCB;

    bool send_set_interface_management(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const bool&	management,
	const SetInterfaceManagementCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetMacCB;

    bool send_set_mac(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const Mac&	mac,
	const SetMacCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr CreateMacCB;

    bool send_create_mac(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const Mac&	mac,
	const CreateMacCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteMacCB;

    bool send_delete_mac(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const Mac&	mac,
	const DeleteMacCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr RestoreOriginalMacCB;

    bool send_restore_original_mac(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const RestoreOriginalMacCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetMtuCB;

    bool send_set_mtu(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const uint32_t&	mtu,
	const SetMtuCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr RestoreOriginalMtuCB;

    bool send_restore_original_mtu(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const RestoreOriginalMtuCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr CreateVifCB;
    /**
     *  Send Xrl intended to:
     *
     *  Create a vif.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param ifname the name of the physical interface associated with the
     *  new vif.
     *
     *  @param vif name for new vif, must be unique across all the vifs in the
     *  system.
     */
    bool send_create_vif(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const CreateVifCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteVifCB;

    bool send_delete_vif(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const DeleteVifCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetVifEnabledCB;

    bool send_set_vif_enabled(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const bool&	enabled,
	const SetVifEnabledCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetVifVlanCB;
    /**
     *  Send Xrl intended to:
     *
     *  Set VLAN vif.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param ifname the name of the physical interface associated with the
     *  VLAN.
     *
     *  @param vif the name of the VLAN.
     *
     *  @param vlan_id the VLAN ID. It must be in the range 0 through 4095.
     */
    bool send_set_vif_vlan(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const uint32_t&	vlan_id,
	const SetVifVlanCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr CreateAddress4CB;

    bool send_create_address4(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	const CreateAddress4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteAddress4CB;

    bool send_delete_address4(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	const DeleteAddress4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetAddressEnabled4CB;

    bool send_set_address_enabled4(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	const bool&	enabled,
	const SetAddressEnabled4CB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const bool*>::RefPtr GetConfiguredAddressEnabled4CB;

    bool send_get_configured_address_enabled4(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	const GetConfiguredAddressEnabled4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetPrefix4CB;

    bool send_set_prefix4(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	const uint32_t&	prefix_len,
	const SetPrefix4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetBroadcast4CB;

    bool send_set_broadcast4(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	const IPv4&	broadcast,
	const SetBroadcast4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetEndpoint4CB;

    bool send_set_endpoint4(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	const IPv4&	endpoint,
	const SetEndpoint4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr CreateAddress6CB;

    bool send_create_address6(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	const CreateAddress6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteAddress6CB;

    bool send_delete_address6(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	const DeleteAddress6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetAddressEnabled6CB;

    bool send_set_address_enabled6(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	const bool&	enabled,
	const SetAddressEnabled6CB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const bool*>::RefPtr GetConfiguredAddressEnabled6CB;

    bool send_get_configured_address_enabled6(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	const GetConfiguredAddressEnabled6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetPrefix6CB;

    bool send_set_prefix6(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	const uint32_t&	prefix_len,
	const SetPrefix6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetEndpoint6CB;

    bool send_set_endpoint6(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	const IPv6&	endpoint,
	const SetEndpoint6CB&	cb
    );

protected:
    XrlSender* _sender;

private:
    void unmarshall_set_restore_original_config_on_shutdown(
	const XrlError&	e,
	XrlArgs*	a,
	SetRestoreOriginalConfigOnShutdownCB		cb
    );

    void unmarshall_get_configured_interface_names(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredInterfaceNamesCB		cb
    );

    void unmarshall_get_configured_vif_names(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredVifNamesCB		cb
    );

    void unmarshall_get_configured_vif_flags(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredVifFlagsCB		cb
    );

    void unmarshall_get_configured_vif_pif_index(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredVifPifIndexCB		cb
    );

    void unmarshall_get_configured_vif_addresses4(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredVifAddresses4CB		cb
    );

    void unmarshall_get_configured_vif_addresses6(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredVifAddresses6CB		cb
    );

    void unmarshall_get_configured_address_flags4(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredAddressFlags4CB		cb
    );

    void unmarshall_get_configured_address_flags6(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredAddressFlags6CB		cb
    );

    void unmarshall_get_configured_interface_enabled(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredInterfaceEnabledCB		cb
    );

    void unmarshall_get_configured_interface_discard(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredInterfaceDiscardCB		cb
    );

    void unmarshall_get_configured_interface_unreachable(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredInterfaceUnreachableCB		cb
    );

    void unmarshall_get_configured_interface_management(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredInterfaceManagementCB		cb
    );

    void unmarshall_get_configured_mac(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredMacCB		cb
    );

    void unmarshall_get_configured_mtu(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredMtuCB		cb
    );

    void unmarshall_get_configured_no_carrier(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredNoCarrierCB		cb
    );

    void unmarshall_get_configured_baudrate(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredBaudrateCB		cb
    );

    void unmarshall_get_configured_vif_enabled(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredVifEnabledCB		cb
    );

    void unmarshall_get_configured_prefix4(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredPrefix4CB		cb
    );

    void unmarshall_get_configured_broadcast4(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredBroadcast4CB		cb
    );

    void unmarshall_get_configured_endpoint4(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredEndpoint4CB		cb
    );

    void unmarshall_get_configured_prefix6(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredPrefix6CB		cb
    );

    void unmarshall_get_configured_endpoint6(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredEndpoint6CB		cb
    );

    void unmarshall_start_transaction(
	const XrlError&	e,
	XrlArgs*	a,
	StartTransactionCB		cb
    );

    void unmarshall_commit_transaction(
	const XrlError&	e,
	XrlArgs*	a,
	CommitTransactionCB		cb
    );

    void unmarshall_abort_transaction(
	const XrlError&	e,
	XrlArgs*	a,
	AbortTransactionCB		cb
    );

    void unmarshall_create_interface(
	const XrlError&	e,
	XrlArgs*	a,
	CreateInterfaceCB		cb
    );

    void unmarshall_delete_interface(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteInterfaceCB		cb
    );

    void unmarshall_configure_all_interfaces_from_system(
	const XrlError&	e,
	XrlArgs*	a,
	ConfigureAllInterfacesFromSystemCB		cb
    );

    void unmarshall_configure_interface_from_system(
	const XrlError&	e,
	XrlArgs*	a,
	ConfigureInterfaceFromSystemCB		cb
    );

    void unmarshall_set_interface_enabled(
	const XrlError&	e,
	XrlArgs*	a,
	SetInterfaceEnabledCB		cb
    );

    void unmarshall_set_interface_discard(
	const XrlError&	e,
	XrlArgs*	a,
	SetInterfaceDiscardCB		cb
    );

    void unmarshall_set_interface_unreachable(
	const XrlError&	e,
	XrlArgs*	a,
	SetInterfaceUnreachableCB		cb
    );

    void unmarshall_set_interface_management(
	const XrlError&	e,
	XrlArgs*	a,
	SetInterfaceManagementCB		cb
    );

    void unmarshall_set_mac(
	const XrlError&	e,
	XrlArgs*	a,
	SetMacCB		cb
    );

    void unmarshall_create_mac(
	const XrlError&	e,
	XrlArgs*	a,
	CreateMacCB		cb
    );

    void unmarshall_delete_mac(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteMacCB		cb
    );

    void unmarshall_restore_original_mac(
	const XrlError&	e,
	XrlArgs*	a,
	RestoreOriginalMacCB		cb
    );

    void unmarshall_set_mtu(
	const XrlError&	e,
	XrlArgs*	a,
	SetMtuCB		cb
    );

    void unmarshall_restore_original_mtu(
	const XrlError&	e,
	XrlArgs*	a,
	RestoreOriginalMtuCB		cb
    );

    void unmarshall_create_vif(
	const XrlError&	e,
	XrlArgs*	a,
	CreateVifCB		cb
    );

    void unmarshall_delete_vif(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteVifCB		cb
    );

    void unmarshall_set_vif_enabled(
	const XrlError&	e,
	XrlArgs*	a,
	SetVifEnabledCB		cb
    );

    void unmarshall_set_vif_vlan(
	const XrlError&	e,
	XrlArgs*	a,
	SetVifVlanCB		cb
    );

    void unmarshall_create_address4(
	const XrlError&	e,
	XrlArgs*	a,
	CreateAddress4CB		cb
    );

    void unmarshall_delete_address4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteAddress4CB		cb
    );

    void unmarshall_set_address_enabled4(
	const XrlError&	e,
	XrlArgs*	a,
	SetAddressEnabled4CB		cb
    );

    void unmarshall_get_configured_address_enabled4(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredAddressEnabled4CB		cb
    );

    void unmarshall_set_prefix4(
	const XrlError&	e,
	XrlArgs*	a,
	SetPrefix4CB		cb
    );

    void unmarshall_set_broadcast4(
	const XrlError&	e,
	XrlArgs*	a,
	SetBroadcast4CB		cb
    );

    void unmarshall_set_endpoint4(
	const XrlError&	e,
	XrlArgs*	a,
	SetEndpoint4CB		cb
    );

    void unmarshall_create_address6(
	const XrlError&	e,
	XrlArgs*	a,
	CreateAddress6CB		cb
    );

    void unmarshall_delete_address6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteAddress6CB		cb
    );

    void unmarshall_set_address_enabled6(
	const XrlError&	e,
	XrlArgs*	a,
	SetAddressEnabled6CB		cb
    );

    void unmarshall_get_configured_address_enabled6(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfiguredAddressEnabled6CB		cb
    );

    void unmarshall_set_prefix6(
	const XrlError&	e,
	XrlArgs*	a,
	SetPrefix6CB		cb
    );

    void unmarshall_set_endpoint6(
	const XrlError&	e,
	XrlArgs*	a,
	SetEndpoint6CB		cb
    );

};

#endif /* __XRL_INTERFACES_FEA_IFMGR_XIF_HH__ */
